
COMMENT Logit Regression Panel (a) of Table 14 3, syntax copyright by Robert B Smith,    2011.
USE ALL.
COMPUTE filter_$=(surg=1).
VARIABLE LABEL filter_$ 'surg=1 (FILTER)'.
VALUE LABELS filter_$  0 'Not Selected' 1 'Selected'.
FORMAT filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE .

WEIGHT
  BY count .

GENLOG
  comps  BY miamihsp precert
  /MODEL = MULTINOMIAL
  /PRINT = FREQ RESID ADJRESID ZRESID DEV ESTIM CORR COV
  /PLOT = RESID( ADJRESID ) NORMPROB( ADJRESID )
  /CRITERIA = CIN(95) ITERATE(20) CONVERGE(.001) DELTA(.5)
  /DESIGN comps comps*miamihsp comps*precert  .

COMMENTLogit Regression Panel (b) of Table 14 3.

USE ALL.
COMPUTE filter_$=(surg=0).
VARIABLE LABEL filter_$ 'surg=1 (FILTER)'.
VALUE LABELS filter_$  0 'Not Selected' 1 'Selected'.
FORMAT filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE .

WEIGHT
  BY count .

GENLOG
  comps  BY miamihsp precert
  /MODEL = MULTINOMIAL
  /PRINT = FREQ RESID ADJRESID ZRESID DEV ESTIM CORR COV
  /PLOT = RESID( ADJRESID ) NORMPROB( ADJRESID )
  /CRITERIA = CIN(95) ITERATE(20) CONVERGE(.001) DELTA(.5)
  /DESIGN comps comps*miamihsp comps*precert  .


COMMENT Logit Regression Across Panels (a) and (b) of Table 14 3.

WEIGHT
  BY count .

FILTER OFF.
USE ALL.
EXECUTE .


GENLOG
  comps  BY surg miamihsp precert
  /MODEL = MULTINOMIAL
  /PRINT = FREQ RESID ADJRESID ZRESID DEV ESTIM CORR COV
  /PLOT = RESID( ADJRESID ) NORMPROB( ADJRESID )
  /CRITERIA = CIN(95) ITERATE(20) CONVERGE(.001) DELTA(.5)
  /DESIGN comps comps*miamihsp comps*precert comps*surg  .


COMMENT The SAS syntax for this table is also available.
